<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Assignment extends Model
{
    protected $table = 'assignments';
    protected $primaryKey = 'Assignment_id';

    protected $fillable = [
        'Lesson_id',
        'User_id',
        'Title',
        'Description',
        'Submitted_at',
        'Status',
        'Grade',
    ];

    protected $casts = [
        'Submitted_at' => 'datetime',
        'Grade' => 'decimal:5,2',
        'Status' => 'string',
    ];

    public function lesson()
    {
        return $this->belongsTo(Lesson::class, 'Lesson_id', 'Lesson_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }
}
